C***********************************************************************
c*SPOFA -- Factor a real symmetrix positive definite matrix.
c:LINPACK
c+
      SUBROUTINE SPOFA(A,LDA,N,INFO)
      INTEGER LDA,N,INFO
      REAL A(LDA,1)
C
C     SPOFA FACTORS A REAL SYMMETRIC POSITIVE DEFINITE MATRIX.
C
C     SPOFA IS USUALLY CALLED BY SPOCO, BUT IT CAN BE CALLED
C     DIRECTLY WITH A SAVING IN TIME IF	 RCOND	IS NOT NEEDED.
C     (TIME FOR SPOCO) = (1 + 18/N)*(TIME FOR SPOFA) .
C
C     ON ENTRY
C
C	 A	 REAL(LDA, N)
C		 THE SYMMETRIC MATRIX TO BE FACTORED.  ONLY THE
C		 DIAGONAL AND UPPER TRIANGLE ARE USED.
C
C	 LDA	 INTEGER
C		 THE LEADING DIMENSION OF THE ARRAY  A .
C
C	 N	 INTEGER
C		 THE ORDER OF THE MATRIX  A .
C
C     ON RETURN
C
C	 A	 AN UPPER TRIANGULAR MATRIX  R	SO THAT	 A = TRANS(R)*R
C		 WHERE	TRANS(R)  IS THE TRANSPOSE.
C		 THE STRICT LOWER TRIANGLE IS UNALTERED.
C		 IF  INFO .NE. 0 , THE FACTORIZATION IS NOT COMPLETE.
C
C	 INFO	 INTEGER
C		 = 0  FOR NORMAL RETURN.
C		 = K  SIGNALS AN ERROR CONDITION.  THE LEADING MINOR
C		      OF ORDER	K  IS NOT POSITIVE DEFINITE.
C
C--
C     LINPACK.	THIS VERSION DATED 08/14/78 .
C     CLEVE MOLER, UNIVERSITY OF NEW MEXICO, ARGONNE NATIONAL LAB.
C
C     SUBROUTINES AND FUNCTIONS
C
C     BLAS SDOT
C     FORTRAN SQRT
C
C     INTERNAL VARIABLES
C
      REAL SDOT,T
      REAL S
      INTEGER J,JM1,K
C     BEGIN BLOCK WITH ...EXITS TO 40
C
C
	 DO 30 J = 1, N
	    INFO = J
	    S = 0.0E0
	    JM1 = J - 1
	    IF (JM1 .LT. 1) GO TO 20
	    DO 10 K = 1, JM1
	       T = A(K,J) - SDOT(K-1,A(1,K),1,A(1,J),1)
	       T = T/A(K,K)
	       A(K,J) = T
	       S = S + T*T
   10	    CONTINUE
   20	    CONTINUE
	    S = A(J,J) - S
C     ......EXIT
	    IF (S .LE. 0.0E0) GO TO 40
	    A(J,J) = SQRT(S)
   30	 CONTINUE
	 INFO = 0
   40 CONTINUE
      RETURN
      END
